# -*- coding: utf-8 -*-
"""
Created on Fri Apr 29 09:57:11 2022

@author: xmls36
"""

# -*- coding: utf-8 -*-
"""
Created on Wed Mar 23 18:40:39 2022

@author: JM wrote the first kernel of the code to plot persistance plots and read in data. APR the rest
"""
"""The first kernel defines basic functions and reads in the data. 
The code is designed to profile switching of a motor or something similar using the signal from a PD
It is used to find the switching time.
It analyses vibrations present during and after the switch,  and can output their p2p height and frequency
It also gives a response time of the switch. 

It is designed to be used with three types of data. 1. A profile of the entire switching
2. A profile of vibrations/oscillations at the end of the switch
3. A profile of the very beginning of the switch to find a switch response time.

After runing the first kernel to read in the data, depending on what is present in the data, run 
one of the next three
"""
import scipy.io
import numpy as np
import matplotlib.pyplot as plt
import matplotlib 
import os
import pandas as pd
import scipy.optimize
from numpy.random import rand,normal
import pickle
from scipy.stats import sem
from scipy.signal import find_peaks

def rotation_fit(t,t0,t1,A,w,phi,c):
    """Fit for rotation data
    """
    V =A*np.cos(w*(t-t0)+phi)+c
    V = np.where(t<t0,A*np.cos(phi)+c,V)
    V = np.where(t>t1,A*np.cos(w*(t1-t0)+phi)+c,V)

    return V

def persistance_plot(t_values,data_list,axes =None,vbins = None):
    """Plot a list of traces with same time base as a 2D histogram
    Imitates persistance mode of an oscilloscope
    Designed to to work with digitised data from picoscope
    """
    if not axes:
        plt.figure()
    if not vbins:
        vbins=len(np.unique(data_list[0]))
    print("Number of vertical bins",vbins)
    
    plt.hist2d(np.tile(t_values, len(data_list)), np.ravel(data_list), bins=(int(len(t_values)/4),vbins),norm= matplotlib.colors.LogNorm())
    plt.colorbar()
    



folder_path = r"Y:\Microscope\People\adarsh\Hollow stepper\\"

measure = "pulse_train\\"
path = folder_path+measure

V_Alist= []
V_Blist = []
i = 0
read = True

if read:
    # Read in data
    os.makedirs(os.path.dirname("testingdata\\"+measure),exist_ok=True)

    for file in os.listdir(path):
            print(file)

            if file.endswith(".mat"):
                
                matfile = scipy.io.loadmat(path+file)

                print(matfile.keys())
                tstart = matfile['Tstart'][0][0]
                # print(tstart)
                samples = matfile['RequestedLength'][0][0] + \
                    matfile['ExtraSamples'][0][0]
                times = np.linspace(tstart, tstart+samples *
                                    matfile['Tinterval'][0][0], samples)
             
                voltageA = np.array(matfile['A'])
                V_Alist.append(voltageA)

                i+=1
                # plt.plot(times,voltageA)
                # plt.show()
                # if i>5:
                    # break
    with open("testingdata\\"+measure+"V_Adata.pkl",'wb') as f:
        pickle.dump(V_Alist,f)
    with open("testingdata\\"+measure+"times.pkl",'wb') as f:
        pickle.dump(times,f)


with open("testingdata\\"+measure+"V_Adata.pkl",'rb') as f:
    V_Alist = pickle.load(f)
with open("testingdata\\"+measure+"times.pkl",'rb') as f:
    times = pickle.load(f)
print(len(V_Alist))



trace_a=np.array(V_Alist)
#trace_a,trace_b is an np array of the traces 

figurepath = "figures\\"+measure
os.makedirs(os.path.dirname(figurepath),exist_ok=True)
#%%
plt.rcParams.update({'font.size': 12})
plt.rcParams['svg.fonttype'] = 'none'
fig, ax1 = plt.subplots()
trace_a=np.array(V_Alist)
ax1.plot(1000*times,trace_a[0],c='b')
plt.xlim(-0.5,28)
plt.ylim(0,10)
ax1.set_ylabel('Voltage (V)',c='b')
ax1.set_xlabel('Time (ms)')

ax2 = ax1.twinx()
ax2.set_ylabel('Velocity (degrees/s)',color='r')
ax2.plot([0,13.5,27],[0,200000*0.9*13.5/1000,0],c='r')
plt.ylim(0,2500)